/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.orb;

import com.visigenic.vbroker.GIOP.CancelRequestHeaderHelper;
import com.visigenic.vbroker.GIOP.LocateReplyHeader;
import com.visigenic.vbroker.GIOP.LocateReplyHeaderHelper;
import com.visigenic.vbroker.GIOP.LocateRequestHeader;
import com.visigenic.vbroker.GIOP.LocateRequestHeaderHelper;
import com.visigenic.vbroker.GIOP.MessageHeader;
import com.visigenic.vbroker.GIOP.MsgType;
import com.visigenic.vbroker.GIOP.ReplyHeader;
import com.visigenic.vbroker.GIOP.ReplyHeaderHelper;
import com.visigenic.vbroker.GIOP.RequestHeader;
import com.visigenic.vbroker.GIOP.RequestHeaderHelper;
import com.visigenic.vbroker.GIOP.Version;
import com.visigenic.vbroker.IOP.IOR;
import com.visigenic.vbroker.IOP.IORHelper;
import com.visigenic.vbroker.orb.Connection;
import com.visigenic.vbroker.orb.GiopConnection;
import com.visigenic.vbroker.orb.GiopConnectionFactory;
import com.visigenic.vbroker.orb.GiopConnectionReplyWaiter;
import com.visigenic.vbroker.orb.GiopInputStream;
import com.visigenic.vbroker.orb.GiopMessage;
import com.visigenic.vbroker.orb.GiopOutputStream;
import com.visigenic.vbroker.orb.ORB;
import com.visigenic.vbroker.orb.ObjectId;
import com.visigenic.vbroker.orb.OrbObject;
import com.visigenic.vbroker.orb.PersistentId;
import com.visigenic.vbroker.orb.ProtocolHandler;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.SystemException;

public class GiopConnectionImpl
implements GiopConnection,
OrbObject {
    private int _requestId;
    private int _refCount = 1;
    private ORB _orb;
    private Connection _connection;
    private Dictionary _waiters = new Hashtable();
    private boolean _reader = false;
    private ProtocolHandler _protocolHandler;
    private boolean _inUse = true;
    private GiopConnectionFactory _factory;
    private long _timeStamp;
    private static final int GIOP_MSGFLAGS_OFFSET = 6;
    private static final int GIOP_MSGSIZE_OFFSET = 8;

    public void init(ORB oRB, Object[] objectArray) {
        this._orb = oRB;
        this._connection = (Connection)objectArray[0];
        this._factory = (GiopConnectionFactory)objectArray[1];
    }

    public synchronized boolean inUse() {
        return this._reader || this._waiters.size() > 0;
    }

    public long lastUsed() {
        return this._timeStamp;
    }

    public String toString() {
        return "GiopConnection[connection=" + this._connection + "]";
    }

    public synchronized int requestId() {
        return this._requestId++;
    }

    public IOR locate(byte[] byArray) {
        ObjectId objectId = this._orb.toObjectId(byArray);
        if (this._orb.debug) {
            this._orb.println("Located oid: " + objectId);
        }
        if (!(objectId instanceof PersistentId)) {
            return null;
        }
        GiopOutputStream giopOutputStream = this._factory.newMessage(MsgType.LocateRequest, false);
        int n = this.requestId();
        LocateRequestHeader locateRequestHeader = new LocateRequestHeader(n, byArray);
        if (this._orb.debug) {
            this._orb.println("Write: " + locateRequestHeader);
        }
        LocateRequestHeaderHelper.write(giopOutputStream, locateRequestHeader);
        GiopMessage giopMessage = this.invoke(n, giopOutputStream);
        if (giopMessage.header().message_type != 4) {
            throw new MARSHAL("Expected a locate reply: " + this._orb.messageType(giopMessage.header()));
        }
        LocateReplyHeader locateReplyHeader = (LocateReplyHeader)giopMessage.operationHeader();
        GiopInputStream giopInputStream = giopMessage.buffer();
        if (this._orb.debug) {
            this._orb.println("Read: " + locateReplyHeader);
        }
        switch (locateReplyHeader.locate_status.value()) {
            case 1: {
                return null;
            }
            case 2: {
                IOR iOR = IORHelper.read(giopInputStream);
                if (this._orb.debug) {
                    this._orb.println("Read: " + iOR);
                }
                return iOR;
            }
            case 0: {
                throw new OBJECT_NOT_EXIST();
            }
        }
        throw new MARSHAL();
    }

    public GiopOutputStream createRequest(RequestHeader requestHeader, boolean bl) {
        GiopOutputStream giopOutputStream = this._factory.newMessage(MsgType.Request, bl);
        RequestHeaderHelper.write(giopOutputStream, requestHeader);
        if (this._orb.debug) {
            this._orb.println("Write: " + requestHeader);
        }
        giopOutputStream.request(requestHeader);
        giopOutputStream.dataOffset(giopOutputStream.offset());
        return giopOutputStream;
    }

    public void send_request(int n, GiopOutputStream giopOutputStream, boolean bl) {
        if (bl) {
            Integer n2 = new Integer(n);
            this._waiters.put(n2, new GiopConnectionReplyWaiter(n));
            try {
                this.send_message(giopOutputStream);
                return;
            }
            catch (SystemException systemException) {
                this._waiters.remove(n2);
                throw systemException;
            }
        }
        this.send_message(giopOutputStream);
    }

    public void send_message(GiopOutputStream giopOutputStream) {
        this._timeStamp = System.currentTimeMillis();
        int n = giopOutputStream.offset();
        giopOutputStream.offset(8);
        giopOutputStream.write_ulong(n - 12);
        giopOutputStream.offset(n);
        try {
            try {
                Connection connection = this._connection;
                synchronized (connection) {
                    this._connection.write(giopOutputStream.bytes(), 0, giopOutputStream.offset());
                }
            }
            catch (SystemException systemException) {
                this.notifyException(systemException);
                throw systemException;
            }
            Object var4_5 = null;
            this._factory.release(giopOutputStream);
            return;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this._factory.release(giopOutputStream);
            throw throwable;
        }
    }

    public boolean poll_reply(int n) {
        throw new INTERNAL("poll_reply not supported yet");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public GiopMessage receive_reply(int n) {
        Object object;
        GiopConnectionReplyWaiter giopConnectionReplyWaiter;
        Integer n2;
        block31: {
            n2 = new Integer(n);
            giopConnectionReplyWaiter = (GiopConnectionReplyWaiter)this._waiters.get(n2);
            if (giopConnectionReplyWaiter == null) {
                return null;
            }
            block23: while (true) {
                switch (giopConnectionReplyWaiter.state) {
                    case 3: {
                        this._waiters.remove(n2);
                        return giopConnectionReplyWaiter.message;
                    }
                    case 4: {
                        this._waiters.remove(n2);
                        giopConnectionReplyWaiter.exception.fillInStackTrace();
                        throw giopConnectionReplyWaiter.exception;
                    }
                }
                object = this;
                // MONITORENTER : object
                if (!this._reader) {
                    this._reader = true;
                    Object var5_5 = null;
                    // MONITOREXIT : object
                    break block31;
                }
                // MONITOREXIT : object
                object = giopConnectionReplyWaiter;
                // MONITORENTER : object
                if (giopConnectionReplyWaiter.state == 2 || giopConnectionReplyWaiter.state == 0) {
                    giopConnectionReplyWaiter.state = 1;
                }
                while (true) {
                    if (giopConnectionReplyWaiter.state != 1) {
                        // MONITOREXIT : object
                        continue block23;
                    }
                    try {
                        giopConnectionReplyWaiter.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                break;
            }
            catch (Throwable throwable) {
                // MONITOREXIT : object
                throw throwable;
            }
        }
        try {
            try {
                switch (giopConnectionReplyWaiter.state) {
                    case 3: {
                        this._waiters.remove(n2);
                        object = giopConnectionReplyWaiter.message;
                        Object var6_7 = null;
                        this._reader = false;
                        this.wakeupReader();
                        return object;
                    }
                    case 4: {
                        this._waiters.remove(n2);
                        giopConnectionReplyWaiter.exception.fillInStackTrace();
                        throw giopConnectionReplyWaiter.exception;
                    }
                }
            }
            catch (SystemException systemException) {
                this._reader = false;
                this.notifyException(systemException);
                throw systemException;
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this._reader = false;
            this.wakeupReader();
            throw throwable;
        }
        while (true) {
            GiopMessage giopMessage;
            int n3;
            if ((n3 = this.getRequestId(giopMessage = this.receive_message())) == n) {
                this._waiters.remove(n2);
                object = giopMessage;
                Object var6_8 = null;
                this._reader = false;
                this.wakeupReader();
                return object;
            }
            giopConnectionReplyWaiter = (GiopConnectionReplyWaiter)this._waiters.get(new Integer(n3));
            if (giopConnectionReplyWaiter == null) continue;
            GiopConnectionReplyWaiter giopConnectionReplyWaiter2 = giopConnectionReplyWaiter;
            // MONITORENTER : giopConnectionReplyWaiter2
            giopConnectionReplyWaiter.message = giopMessage;
            giopConnectionReplyWaiter.state = 3;
            giopConnectionReplyWaiter.notify();
            // MONITOREXIT : giopConnectionReplyWaiter2
        }
    }

    public void cancel_request(int n) {
        throw new INTERNAL("Connection pooling not supported");
    }

    public GiopOutputStream createReply(ReplyHeader replyHeader, boolean bl) {
        GiopOutputStream giopOutputStream = this.newMessage(MsgType.Reply, bl);
        ReplyHeaderHelper.write(giopOutputStream, replyHeader);
        if (this._orb.debug) {
            this._orb.println("Write: " + replyHeader);
        }
        giopOutputStream.dataOffset(giopOutputStream.offset());
        return giopOutputStream;
    }

    public void sendClose() {
        GiopOutputStream giopOutputStream = this.newMessage(MsgType.CloseConnection, false);
        this.send_message(giopOutputStream);
    }

    public GiopOutputStream createLocateReply(LocateReplyHeader locateReplyHeader, boolean bl) {
        GiopOutputStream giopOutputStream = this.newMessage(MsgType.LocateReply, bl);
        LocateReplyHeaderHelper.write(giopOutputStream, locateReplyHeader);
        giopOutputStream.dataOffset(giopOutputStream.offset());
        return giopOutputStream;
    }

    public GiopMessage invoke(int n, GiopOutputStream giopOutputStream) {
        this.send_request(n, giopOutputStream, true);
        return this.receive_reply(n);
    }

    public GiopOutputStream newMessage(MsgType msgType, boolean bl) {
        return this._factory.newMessage(msgType, bl);
    }

    public void readMessageHeader(MessageHeader messageHeader, GiopInputStream giopInputStream) {
        messageHeader.magic[0] = giopInputStream.read_char();
        messageHeader.magic[1] = giopInputStream.read_char();
        messageHeader.magic[2] = giopInputStream.read_char();
        messageHeader.magic[3] = giopInputStream.read_char();
        messageHeader.GIOP_version.major = giopInputStream.read_octet();
        messageHeader.GIOP_version.minor = giopInputStream.read_octet();
        messageHeader.flags = giopInputStream.read_octet();
        messageHeader.message_type = giopInputStream.read_octet();
        messageHeader.message_size = giopInputStream.read_ulong();
    }

    public GiopMessage receive_message() {
        boolean bl;
        Object object;
        GiopMessage giopMessage = this._factory.getMessage();
        GiopInputStream giopInputStream = giopMessage.buffer();
        giopInputStream.offset(0);
        giopInputStream.byteOrder(false);
        byte[] byArray = giopInputStream.bytes();
        this._connection.read(byArray, 0, 12);
        MessageHeader messageHeader = giopMessage.header();
        try {
            this.readMessageHeader(messageHeader, giopInputStream);
            char[] cArray = messageHeader.magic;
            if (cArray[0] != 'G' || cArray[1] != 'I' || cArray[2] != 'O' || cArray[3] != 'P') {
                throw new MARSHAL("Message contained invalid magic number: " + new String(cArray));
            }
            object = messageHeader.GIOP_version;
            if (((Version)object).major != 1 || ((Version)object).minor != 0) {
                String string = "Invalid IIOP Version: " + ((Version)object).major + "." + ((Version)object).minor + " != 1.0";
                if (((Version)object).major == 0 && ((Version)object).minor == 0) {
                    string = String.valueOf(string) + " >>> ORBix(tm) does fully support org.omg.CORBA 2.0 (e.g. IIOP 1.0) yet!!! <<<";
                }
                throw new MARSHAL(string);
            }
        }
        catch (MARSHAL mARSHAL) {
            if (this._protocolHandler != null) {
                byte[] byArray2 = new byte[12];
                System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
                this._protocolHandler.handle(byArray2, this._connection);
                giopMessage.release();
                return this.receive_message();
            }
            throw mARSHAL;
        }
        catch (SystemException systemException) {
            giopMessage.release();
            throw systemException;
        }
        boolean bl2 = bl = (messageHeader.flags & 1) == 1;
        if (bl) {
            messageHeader.message_size = this._orb.swapInPlace(messageHeader.message_size);
        }
        if (this._orb.debug) {
            this._orb.println("Read [" + this._orb.messageType(messageHeader) + "]: " + messageHeader);
        }
        if (messageHeader.message_size > byArray.length - 12) {
            if (this._orb.debug) {
                this._orb.println("Message size larger than default, allocating new buffer.");
            }
            object = giopMessage;
            byte[] byArray3 = new byte[12 + messageHeader.message_size];
            System.arraycopy(byArray, 0, byArray3, 0, 12);
            giopMessage = new GiopMessage(this._orb, byArray3);
            giopMessage.header(((GiopMessage)object).header());
            messageHeader = giopMessage.header();
            giopInputStream = giopMessage.buffer();
            giopInputStream.offset(12);
            byArray = byArray3;
            ((GiopMessage)object).release();
        }
        this._connection.read(byArray, 12, messageHeader.message_size);
        giopInputStream.byteOrder(bl);
        giopInputStream.length(messageHeader.message_size + 12);
        switch (messageHeader.message_type) {
            case 0: {
                giopMessage.operationHeader(RequestHeaderHelper.read(giopInputStream));
                giopInputStream.dataOffset(giopInputStream.offset());
                break;
            }
            case 1: {
                giopMessage.operationHeader(ReplyHeaderHelper.read(giopInputStream));
                giopInputStream.dataOffset(giopInputStream.offset());
                break;
            }
            case 3: {
                giopMessage.operationHeader(LocateRequestHeaderHelper.read(giopInputStream));
                break;
            }
            case 4: {
                giopMessage.operationHeader(LocateReplyHeaderHelper.read(giopInputStream));
                break;
            }
            case 2: {
                giopMessage.operationHeader(CancelRequestHeaderHelper.read(giopInputStream));
                break;
            }
            case 5: 
            case 6: {
                giopMessage.operationHeader(null);
                break;
            }
            default: {
                giopMessage.release();
                throw new MARSHAL();
            }
        }
        return giopMessage;
    }

    private void notifyException(SystemException systemException) {
        Dictionary dictionary = this._waiters;
        synchronized (dictionary) {
            Enumeration enumeration = this._waiters.elements();
            while (enumeration.hasMoreElements()) {
                GiopConnectionReplyWaiter giopConnectionReplyWaiter;
                GiopConnectionReplyWaiter giopConnectionReplyWaiter2 = giopConnectionReplyWaiter = (GiopConnectionReplyWaiter)enumeration.nextElement();
                synchronized (giopConnectionReplyWaiter2) {
                    if (giopConnectionReplyWaiter.state == 1 || giopConnectionReplyWaiter.state == 0) {
                        giopConnectionReplyWaiter.exception = new COMM_FAILURE(systemException.getMessage(), systemException.minor, systemException.completed);
                        giopConnectionReplyWaiter.state = 4;
                        giopConnectionReplyWaiter.notify();
                    }
                }
            }
            return;
        }
    }

    private int getRequestId(GiopMessage giopMessage) {
        switch (giopMessage.header().message_type) {
            case 1: {
                return ((ReplyHeader)giopMessage.operationHeader()).request_id;
            }
            case 4: {
                return ((LocateReplyHeader)giopMessage.operationHeader()).request_id;
            }
            case 5: {
                giopMessage.release();
                throw new COMM_FAILURE("CloseConnection message received from server.");
            }
        }
        giopMessage.release();
        throw new MARSHAL("Unexpected message type: " + giopMessage.header().message_type);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void wakeupReader() {
        Dictionary dictionary = this._waiters;
        synchronized (dictionary) {
            if (this._waiters.isEmpty()) {
                return;
            }
            Enumeration enumeration = this._waiters.elements();
            while (enumeration.hasMoreElements()) {
                GiopConnectionReplyWaiter giopConnectionReplyWaiter = (GiopConnectionReplyWaiter)enumeration.nextElement();
                if (giopConnectionReplyWaiter.state != 1) continue;
                GiopConnectionReplyWaiter giopConnectionReplyWaiter2 = giopConnectionReplyWaiter;
                synchronized (giopConnectionReplyWaiter2) {
                    giopConnectionReplyWaiter.state = 2;
                    giopConnectionReplyWaiter.notify();
                    return;
                }
            }
            return;
        }
    }

    public void close() {
        this._factory.destroy(this, true);
        Dictionary dictionary = this._waiters;
        synchronized (dictionary) {
            this.notifyException(new COMM_FAILURE("Connection closed by application"));
            this._factory.close(this);
            return;
        }
    }

    public Object clone() {
        Object[] objectArray = new Object[]{this._connection.clone(), this._factory};
        return (GiopConnection)this._orb.create(32, objectArray);
    }

    public void setProtocolHandler(ProtocolHandler protocolHandler) {
        this._protocolHandler = protocolHandler;
    }

    public Connection connection() {
        return this._connection;
    }

    public void release() {
        boolean bl = false;
        GiopConnectionImpl giopConnectionImpl = this;
        synchronized (giopConnectionImpl) {
            if (--this._refCount == 0) {
                bl = true;
            }
        }
        if (bl) {
            this._factory.destroy(this, false);
        }
    }

    public synchronized GiopConnection duplicate() {
        ++this._refCount;
        return this;
    }

    public int refCount() {
        return this._refCount;
    }
}

